"A Twisted Tail" by Phillip Lovetere

When play begins:
	say "This game plays best while being read in a southern drawl, particularly in a crowded public place loudly enough for everyone to hear. The author takes absolutely no responsibility for any damages, physical or emotional, which may result from playing this game."


section 0 - VARIABLES/RULES

[A volume is a kind of value. 15.9 fl oz specifies a volume with parts ounces and tenths.

A fluid container is a kind of container. A fluid container has a volume called a fluid capacity. A fluid container has a volume called current volume.
The fluid capacity of a fluid container is usually 18.0 fl oz. The current volume of a fluid container is usually 0.0 fl oz.]

A thing can be examined or unexamined. A thing is usually unexamined. After examining something: now the noun is examined; continue the action.

A thing can be Sharp or UnSharp. A thing is usually UnSharp.

A thing can be Enchanted or UnEnchanted. A thing is usually UnEnchanted.

A thing can be Magical or NonMagical. A thing is usually NonMagical.

A thing can be Firearm or NotFirearm. A thing is usually NotFirearm.

A thing can be Loaded or UnLoaded. A thing is usually UnLoaded.

A thing can be Fluid or NotFluid. A thing is usually NotFluid.

A thing can be FluidFull or FluidEmpty. A thing is usually FluidEmpty.

GunEnchanted is a truth state variable.
GunEnchanted is false.

GunSag is a truth state variable.
GunSag is false.

ShootForTheEyes is a truth state variable.
ShootForTheEyes is false.

[A container can be broken or unbroken. A container is usually unbroken.]

Instead of taking Old Pistol:
	if meltedGun is in holster:
		say "Ya need ta empty yer holster [']afore you can carry such a delicate piece [']round with ya!";
		stop the action;
	else:
		say "Ya gingerly slide yer new best friend into its place of residence.";
		now Old Pistol is in holster;
		stop the action.

Rule for implicitly taking the Smith's Chest:
	say "The chest is too heavy fer ya ta pick up!"
	

Instead of going nowhere:
	say "Nothin['] but desert in that direction. You wouldn't make it anywhere without a horse, anyway."



Shooting is an action applying to one visible thing.

Check Shooting:
	if Old Pistol is not in holster:
		say "Ya can['] shoot nothin['] with that!";
		stop the action;
	else if Old Pistol is UnLoaded:
		say "Ya need to load it [']afore it[']ll shoot!";
		stop the action;
	else if player is wearing Smith's Gloves:
		say "Ya can[']t hold yer gun, let alone pull the trigger with those gloves on!";
		stop the action;
	else if the noun is not an animal:
		say "Ya don[']t reckon it[']d do much good ta shoot that.";
		stop the action;
	else if Old Pistol is UnEnchanted:
		say "Yer gun sags as ya try to aim it; happens to the best of us.";
		now GunSag is true;
		stop the action.
		
Carry out Shooting:
	end the story finally saying "Ya pull the trigger on the ol' flintlock; lucky Smithy kept such good care [']a the ol['] thing, it fires without a hitch. The poodle bursts like a stick [']a dynamite were crammed up [']n it, not that it[']d much surprise ya with the unholy goin[']s on with Ms. Crowley [']n her...[italic type]peculiarities[roman type]. Caught [']n the splash zone ain[']t a pleasant experience, [']n ya turn back ta town ta take a load off at Mulligan[']s. Then ya remember wha[']cha first saw when ya woke up. Ya managed to kill the poodle, but what price didja pay fer it, ya think as a tear comes ta yer eye."[[paragraph break]Ya look a['] the unmentionable hangin['] at yer waist, [']n give it a whirl. If it can make someone else[']s dreams come true, why not yers? St. Mulligan[']s rebuilds itself [']afore yer eyes, in all its dank wonderful glory. [']N so does the jail ya were still locked [']n when ev[']rone ran.[paragraph break]Wait, wha?[paragraph break]Ya look at the tin star melted inta yer shirt, [']n realize it ain[']t yers. "]

filling is an action applying to one carried thing.

Instead of taking off TinStar:
	say "Ya would if ya could, but it[']s melted inta yer shirt!"

Check filling:
	if noun is NotFluid:
		say "Ya[']d try, but that idea jus['] don[']t hold water.";
		stop the action;
	else if noun is FluidFull:
		say "Ya got enough water in there, right now.";
		stop the action.
		
Carry out filling:
	say "Ya fill yer bottle to the brim.";
	now the noun is FluidFull;
	stop the action.

Loading is an action applying to one thing.

Check Loading:
	if noun is NotFirearm:
		say "Ya doubt bullets[']d do much good jammed in [italic type]that.";
		stop the action;
	else if noun is Loaded:
		say "It ain't wise to put too many bullets in this ol['] thing; it's already loaded.";
		stop the action.
		
Carry out Loading:
	say "Ya load a bullet and a lil['] powder from yer belt; at least [italic type]those[roman type] hadn[']t melted.";
	now the noun is Loaded;
	stop the action.
	



Interrogating it about is an action applying to two visible things. 

 
Check Interrogating it about:
	if noun is not a person:
		say "Were you really expecting to get a reply?";
		stop the action.
 
Carry out Interrogating it about:
	say "You attempt to converse, but on that subject [noun] has nothing to say."

prying is an action applying to one carried thing and one thing.
[prying is an action applying to the Wooden Wedge and the Smith's Chest.]

enchanting is an action applying to one carried thing and one visible thing.

When play begins:
	now the player is wearing the holster;
	now the player is wearing TinStar.
	
Instead of unlocking holster with the WoodWedge:
	say "Ya pry yer old .44 free with the latch [']n toss it aside; ya won't be needin['] it anymore, after all!";
	now the holster is unlocked;
	now the holster is open;
	now the holster is unopenable;
	now meltedGun is nowhere.
	
Instead of unlocking Smith's Chest with the WoodWedge:
	say "Ya pry the chest open, wreckin['] it [']n the process. Ya hope Smithy won[']t mind, but then again, ya don[']t really care.";
	now the Smith's Chest is unlocked.
	
[After prying for the first time:
	if the player is in GunSmith:
		now the Smith's Chest is unlocked;
	else:
		now holster is unlocked;
		now meltedGun is nowhere;
	
After prying for the second time:
	if the Smith's Chest is unlocked:
		now holster is unlocked;
		now meltedGun is nowhere;
	else:
		now the Smith's Chest is unlocked.]
	
[check prying:
	if the carried thing is UnSharp:
		say "You can't pry with that!";
		stop the action.]
	[else if the visible thing is not a container:
		say "You can't pry that!";
		stop the action.]
		
[Carry out prying:
	say "You use the wedge to pry yer holster open; ya toss yer useless .44 aside.";
	[now the second noun is unlocked;]
	stop the action.]
	
[Instead of enchanting Old Pistol:
	if the player is not carrying MagicDildo:
		say "You'll need something magical to perform an enchantment.";
		stop the action;
	else if the player is not wearing Smith's Gloves:
		say "Yer not holdin['] any unmentionables without proper protection on-hand.";
		stop the action;
	else:
		say "The runes scratched into the unmentionable glow blindingly bright for a second after ya wave it around like an idjit before fadin['] back into a dim glow; ya can't see anythin['] different about whacha used it on, but maybe somethin[']s different about it.";
		if GunSag is true:
			say "The ol' thang straightens back up, much ta yer relief.";
		else:
			say "The ol' flintlock glows in a magical sorta way, now.";
	now Old Pistol is Enchanted.]
	
		
	
[check enchanting:
	if the carried thing is NonMagical:
		say "You'll need something magical to perform an enchantment.";
		stop the action;
	else if the player is not wearing Smith's Gloves:
		say "Yer not holdin['] any unmentionables without proper protection on-hand.";
		stop the action;
	else if the visible thing is Enchanted:
		say "The Unmentionable fizzles; it appears as though enchantments don't stack.";
		stop the action.]
		
Carry out enchanting:
	if the player is carrying MagicDildo:
		say "The runes scratched into the unmentionable glow blindingly bright for a second after ya wave it around like an idjit before fadin['] back into a dim glow.";
		now the noun is Enchanted;
		now the second noun is Enchanted;
		if GunSag is true and Old Pistol is the noun or Old Pistol is the second noun:
			say "The ol['] thang straightens back up, much ta yer relief.";
	else:
		say "Ya need more mojo in yer life ta get things enchanted.";
		stop the action.
	
		
		
Instead of taking MagicDildo:
	if the player is wearing Smith's Gloves:
		say "Yer wearin['] gloves, which is marginally better, but ya still handle the thing with care.";
		now the player is carrying MagicDildo;
	else:
		say "Yer not touchin['] that thing, even if yer life [italic type]depends[roman type] on it."
		
Instead of Interrogating stranger about an item listed in the Table of stranger Responses:
	say "[reply entry][paragraph break]".
	
Table of stranger Responses
Item				reply
MagicDildo				"'Keep that thing away from me!', the stranger replies, 'Magic [']n enchantments [']re the work [']a the devil! Don[']cha go enchantin['] willy-nilly wi['] that thang jus['] [']cause I told ya that that[']s what it does!'"
meltedGun				"'Same thing happened ta mine, [']n everyone else[']s; it's magic, I tell ya! You don[']t got none, you won[']t beat none.'"
White Dot				"The terrified stranger[']s eyes go wide as he seems to recall something truly terrifying and horrific. Kinda like the brothel bein['] obliterated. 'It...it was that thrice-damned poodle!', he says, shaking, 'We tried hirin['] an exorcist after Ms. Crowley up [']n bought that tool [']a the devil! I told [']er! I says not to be tempted by the devil! [']s just not natural! Townsfolk [']n I agreed to put a stop to it, but when we held [']er down to exorcise it, somebody up [']n fumbled it, [']n that dumb poodle [']a hers bit right inta the thing.' He looks away guiltily before lookin['] back at ya. 'Ya gotta stop it, Billy! Stop it [']afore somethin['] worse happens! I need St. Mulligan[']s in ma life!' Ya don't have the heart to tell [']im otherwise. 'Remember; shoot fer the eyes, Billy! Shoot fer the eyes!'"
Mountains				"They're a looong way off, Billy. Nothin['] here[']d keep ya from dyin['] [']a thirst [']afore ya got anywhere close."
Water				"[']less ya wanna take a dip in the horse trough outside, [']fraid I can[']t help ya."
Steak Bone				"The stranger sniffs a bit. '...dat was the favorite bone [']a Crowley[']s dog.' He seems a bit hurt at the betrayl from the lil['] brainless yapper."

		
[Instead of interacting with holster:
	if the holster is locked:
		say "The gun's all but fused to the inside; you'll need somethin['] more than yer bare hands to get it out.";
	else:
		say "Taken.";
		now the thing is no longer in the holster;
		now the player has the thing;
		stop the action.]

section 1 - ROOMS

townCenter is a room. "[if unvisited]You wake up, ash and dust clingin['] to your face. Your ears are ringing, but from what, you have no idea. You pick yourself up off the ground to see that half a['] yer town is still smolderin[']. All that[']s in your immediate vicinity is a little smoke and a lotta debris, yet most of the buildings around ya are relatively untouched. Most. You look down to your sidearm - melted right into the holster, as though by magic. You can see a tin star pinned to your shirt; you reckon you must[']ve been a sheriff or marshall in this town [']afore everything went right tits up. To the EAST you spot a building with a sign saying 'St. Mulligan[']s house of Doo-Batchery'. It collapses almost immediately, joinin['] the rubble at yer feet as a distant white speck hovers through where the building once stood and off into the desert beyond. Maybe shootin['] first afore askin['] yerself how the mayhem started woulda been wiser. [else]You[']re standin['] in the rubble of the town center. To the EAST is nothin['] but desert. [end if]To the WEST you see a bank past the trail of rubble, which veers off to the SOUTHWEST. To the NORTH you see a saloon adjacent to a horse trough and cart to the NORTHEAST. To the SOUTH is the local gunsmith[']s workshop.[if unvisited] Ya get the feelin['] you should probably take a closer look at yer surroundings [']afore headin['] any which way.[end if]".
The printed name of townCenter is "Town Center".

bank is west of townCenter. "[if unvisited]You pick yer way through the rubble to the bank. [end if]It looks like those yella-bellies up [']n fled when trouble started, judgin['] by the gapin['] hole in the buildin['], and another one further back, where the teller[']s counter shoulda been.[if unvisited] The room-sized safe is lyin['] wide open behind it, not even a single half-cent left inside.[else] The room-sized safe is lyin['] behind it.[end if]".
The printed name of bank is "Bank".

SandR is north of townCenter. "[if unvisited]You saunter on over to the local waterin['] hole inside [']a which a shaken-up stranger hidin['] behind the bar gestures to ya to join [']im. [end if]Lookin['] round, not much sets this place far from the average outhouse, [']cept fer the adjacent kitchen. Somethin['] tells ya not ta touch anythin['] with a low alcohol content, includin['] the people."
The printed name of SandR is "Saloon".

PoodleHouse is southwest of townCenter. "Followin['] the trail [']a rubble back to the start, you reckon you can make out the remains [']a some big, fancy house at the end. Nothin['] but rubble left over, now. Back to the NORTHEAST is the town center."
The printed name of PoodleHouse is "Trail of Destruction".

GunSmith is south of townCenter. "[if unvisited]As the sayin['] out west goes, 'God didn[']t make men equal; Samuel Colt did', though you suspect you[']ll have to amend that statement seein['] all the guns [']round ya turned to puddles like yer .44. Still though, might be somethin['] left intact. [else]The guns left on the walls [']n shelves [']ve all run down [']em like metal icicles. [end if]".
The printed name of GunSmith is "Gun Smith's Workshop".

Cart is northEast of townCenter. "An empty cart, with all the wheels stripped off and replaced with dirt piles, sits before you.[if unvisited] You reckon the thieves were too poor to afford cinderblocks.[end if] Behind you is a horse trough filled with water, not that you see any horses around to take advantage."

Desert is east of townCenter. "A vast, dry wasteland spreads out before ya. Or it was, [']till a huge hole opened up [']n the ground [']n front [']a ya.[if unvisited] In the air, hoverin['], is...a poodle, facin['] away from ya, bein['] too focused on somehow diggin['] the hole, which is all you can think as dirt keeps flyin['] out of it fast as Bachalisimo[']s food shoots outta...somethin['] else. You can feel in yer gut that this little fella [']ll kill ya as soon as look a[']cha - literally. It takes everythin['] just to keep yerself from saggin['] like yer tin star.[else] That darn poodle[']s still diggin['] a hole for whatever reason, hoverin['] with its back to ya.[end if]".


section 2 - ROOM CONNECTIONS

section 3 - BACKDROPS



section 4 - SCENERY

part 1 - townCenter

bink is scenery in townCenter. [conditional synonyms used to separate description of this from descriptons of bank from the inside]

SaloonAndRestaurant is scenery in townCenter.

GunSmithFromAfar is scenery in townCenter.

CartFromAfar is scenery in townCenter.

HorseTroughFromAfar is scenery in townCenter.

DesertFromAfar is scenery in townCenter.

part 2 - GunSmith

Icicles is scenery in GunSmith.


section 5 - DESCRIPTIONS


part 1 - townCenter

Instead of examining bink when the player is in the townCenter:
	say "A building labeled 'Genericimo[']s Municipal Bank - we keep yer money 'safe'!'.[if unexamined] Just readin['] the sign makes yer trigger finger itch, but the dilapidated nature of the establishment seems to indicate no one[']s inside.[end if]".
	
The description of SaloonAndRestaurant is "Some sorta saloon-restaurant, judgin['] by the sign, 'Bachalisma[']s Barbeque', tacked onto the end of the [']Saloon['] sign. Somehow, the name don[']t inspire much confidence in the sanitary practices o['] the establishment in question. [if unexamined]You see some movement from behind the doors - looks like somebody might be inside.[end if]".

The description of DesertFromAfar is "Nothin['] but desert for miles endin['] in the mountains to the EAST[if unexamined] - where that white dot ya saw earlier drifted off to, come to think of it[end if]."

The description of GunSmithFromAfar is "An open-air shop with a sign readin['] 'Smithy the Gun Smith[']s Firearm Emporium. If you can't kill it...' The rest of the original sign is covered by a new one, sayin['] 'NO REFUNDS'.[if unexamined] Ya look down to the side at yer .44. Dang.[end if]".

The description of CartFromAfar is "A generic-lookin' cart used for travelin'. All the wheels [']ve been taken off [']n replaced with mounds of dirt, so you doubt anythin['] useful[']s still inside."

The description of HorseTroughFromAfar is "A horse trough full [']a water.[if unexamined] Some would say only real men drink whisky, but you'd be inclined to disagree.[end if]".
	

part 2 - bank

Instead of examining safe:
	say "A thick steel box with about as much room as a carriage. Wouldn[']t wanna get stuck inside, given it only unlocks from the front."
	

part 3 - GunSmith

Instead of examining Smith's Chest:
	if Smith's Chest is locked:
		say "A plain wooden chest with its metal lock melted shut. Ya wonder if ya might 'illegitimately' unlock it with a crowbar er somethin['] [']a that persuasion while Smithy ain[']t around to complain.";
	else if Smith's Chest is open:
		say "Formerly a wooden chest, pried [']n hacked apart in frustration."
		
The description of Icicles is "Sharp metal spikes juttin['] downward from some shelves."

The description of Smith's Gloves is "A thick, hefty pair of leather gloves, perfect for keepin' the heat off of 'em. When a pair of oven mitts just ain[']t good enough."

The description of Old Pistol is "An ol['] outdated flintlock that's seen better days. Seems more like an heirloom than merchandise."


part 4 - Items

Instead of examining holster:
	if holster is locked:
		say "A fine-lookin['] holster made outta pressed animal hide. Shame there[']s a pool of your six-shooter stuck inside. Maybe ya could use somethin['] ta forcefully unlock the latch ov[']r the top.";
	else:
		say "Yer trusty holster, much better lookin['] without a melted piece inside."
		
The description of TinStar is "A five-pointed tin star, lookin['] a little droopy from whatever melted yer shootin['] stick. "
		
part 5 - SandR

The description of Bottle is "A plain ol['] glass bottle. Don[']t worry [']bout where it[']s been."
		
The description of bar is "The bar don[']t look like it[']s been wiped down since it was first built - not that anyone here seems to mind. He[']s still cowerin['] [italic type]behind[roman type] it."
		

The description of meltedGun is "A gleaming .44 Colt, now just a pile a scrap to be mourned over.[if unexamined] Too bad ya can[']t get the darn thing outta the holster.[end if]".

The description of Steak Bone is "An ol['] steak bone, stripped [']a anythin['] edible. Seems like the smell[']d attract all sorts [']a critters."

part 6 - Desert

The description of Poodle is "A terrifyin['] lil['] purebred, floatin['] upright with its back to ya like it thinks it[']s a person."

section 6 - SYNONYMS

part 0 - Actions and Starting Inventory

[understand "pry [a locked container] open with [a carried thing]" and "use [a carried thing] on [a locked container]" and "pry [a locked container] with [a carried thing]" and "use [a carried thing] to pry open [a locked container]" and "open [a locked container] with [a carried thing]" and "pry open [a locked container] using [a carried thing]" and "pry [a locked container] using [a carried thing]"  as prying.]

[understand "open [a visible thing] with [a carried thing]" as prying.]
[understand "use [a carried thing] to open [a visible thing]" and "use [a carried thing] to pry [a visible thing]" and "use [a carried thing] to pry open [a visible thing]" and "use [a carried thing] to pry [a visible thing] open" as prying.]

understand "melted gun" and "Melted Gun" as meltedGun.

understand "enchant [a visible thing] using [a carried thing]" and "use [a carried thing] to enchant [a visible thing]" as enchanting.

Understand "ask [something] about [any thing]" and "ask [something] about [any thing]" and "ask [someone] for [any thing]" and "talk to [someone] about [any thing]" as interrogating it about.

understand "tin star" and "Tin Star" and "star" and "Star" as TinStar.

understand "shoot [a visible thing]" as Shooting.

understand "load [a thing]" and "Load [a thing]" as Loading.


part 1 - townCenter building exterior distinctions

understand "Bank" and "bank" and "money hole" and "Genericimo's Municipal Bank" as bink when player is in townCenter.

understand "Bank" and "money hole" and "Genericimo's Municipal Bank" as bank when player is in bank.

understand "Saloon" and "Restaurant" and "saloon" and "restaurant" as SaloonAndRestaurant when player is in townCenter.

understand "Saloon" and "Restaurant" and "saloon" and "restaurant" as SandR when player is in SandR.

understand "workshop" and "Workshop" and "gunsmiths' workshop" and "Smithy's" and "Gunsmith's" as GunSmithFromAfar when player is in townCenter.

understand "workshop" and "Workshop" and "gunsmiths' workshop" and "Smithy's" and "Gunsmith's" as GunSmith when player is not in townCenter.

understand "desert" and "Desert" as DesertFromAfar when player is in townCenter.

understand "desert" and "Desert" as Desert when player is not in townCenter.

understand "Horse Trough" and "horse trough" and "trough" and "Trough" as HorseTroughFromAfar when player is in townCenter.

part 2 - PoodleHouse

understand "unmentionable" and "Unmentionable" and "wand" and "Wand" and "dildo" and "Dildo" and "magic wand" and "magic dildo" and "Magic Dildo" as magicDildo.

understand "wedge" and "Wedge" and "wooden wedge" and "wood wedge" as WoodWedge.

part 3 - GunSmith

understand "icicles" and "spikes" and "Spikes" as Icicles.

understand "gloves" and "Gloves" and "smith gloves" and "smith's gloves" as Smith's Gloves.

understand "Chest" and "chest" and "smith's chest" as Smith's Chest.


part 4 - SandR

understand "stranger" as Stranger.

understand "Poodle" and "poodle" and "white dot" and "dot" and "destruction" and "disaster" and "what happened" and "rubble" and "white speck" and "speck" as White Dot when player is in SandR.

understand "water" and "thirst" as Water when player is in SandR.

understand "mountains" as Mountains.

understand "bottle" as Bottle.






section 7 - ITEMS and PEOPLE

	[puzzle: getting melted gun out of holster using stick]
	
holster is a locked transparent container.
holster is a wearable thing.
holster can hold one thing.

meltedGun is a thing inside holster. 
The printed name of meltedGun is "Melted Gun".

TinStar is a wearable thing.
The printed name of TinStar is "Tin Star".

part 1 - bank

safe is a unlocked open container in bank.
safe is scenery.

part 2 - PoodleHouse

Rubble is a supporter in PoodleHouse. Rubble is scenery.

WoodWedge is a thing on Rubble.
WoodWedge is Sharp.
WoodWedge unlocks Smith's Chest.
WoodWedge unlocks holster.
The printed name of WoodWedge is "a Wooden Wedge".
The description of WoodWedge is "A rather large, sharp piece of wood broken off from a solid piece of timber found in the debris."

MagicDildo is a thing in PoodleHouse.
MagicDildo is Magical.
The printed name of MagicDildo is "an Unmentionable".
The description of MagicDildo is "An untouchable entity originatin['] from the darkest recesses [']a the richest ol['] bat in town. Somethin['] tells ya that wan[']t the original intent of use, if the glowin['] runes scratched into it are any indication."


part 3 - GunSmith

Smith's Chest is a locked, closed container in GunSmith. "Smithy's smithin['] chest sits in the corner."
[Smith's Chest is immobile.]
Old Pistol is a thing in the Smith's Chest.
Old Pistol is Firearm.
Smith's Gloves is a wearable thing in the Smith's Chest.

[note: lock is melted solid at first, need to use wood splinter to pry metal icicle off of wall to smash through/pry open chest]

part 4 - Saloon and Restaurant

Stranger is a person in SandR. Stranger is scenery.

Shelf is a supporter in SandR. Shelf is scenery.

BarCounter is a supporter in SandR. BarCounter is scenery. 
The printed name of BarCounter is "Bar Counter".

Bottle is a thing on Shelf in SandR. "A single intact bottle sits on the shelf behind the bar amid its broken counterparts.[if unexamined] 'Such a waste of booze', ya think to yourself with a tear in yer eye.[end if]".
Bottle is Fluid.

Steak Bone is a thing on BarCounter. "A steak bone, stripped [']a anythin['] edible, sits on the bar counter."

White Dot is a thing in SandR. White Dot is scenery.

Mountains is a thing in SandR. Mountains is scenery.

Water is a thing in SandR. Water is scenery.

part 5 - Desert

Poodle is an animal in Desert. 


	

	




